/**
 * \file: NaviStatusChannel.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: AAuto
 *
 * \author: M. Adachi / ADITJ/SW / madachi@jp.adit-jv.com
 *
 * \copyright (c) 2013-2016 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef AAUTO_NAVISTATUS_CHANNEL_H
#define AAUTO_NAVISTATUS_CHANNEL_H

#include <string>

/* GalReceiver headers */
#include <aauto/GalReceiver.h>
#include <aauto/util/shared_ptr.h>
#include <aauto/NavigationStatusEndpoint.h>
#include <aauto/AditNavigationStatus.h>

#include "SensorSourceChannel.h"

namespace adit { namespace aauto {

class NaviStatusChannel : public IAditNavigationStatusCallbacks
{
public:
    NaviStatusChannel(::shared_ptr<GalReceiver> inReceiver, uint8_t inSessionId,SensorSourceChannel* inSensor);
    virtual ~NaviStatusChannel();
    bool Initialize();
    void shutdown();

    //IAditNavigationStatusCallbacks
    void navigationStatusCallback(int status);
    void navigationNextTurnCallback(const std::string &road, int turnSide, int event, const std::string &image, int turnAngle, int turnNumber);
    void navigationNextTurnDistanceCallback(int distanceMeters, int timeSeconds, int displayDistanceE3,
                                      NavigationNextTurnDistanceEvent_DistanceUnits displayDistanceUnit);

private:
    uint8_t mSessionId;
    ::shared_ptr<GalReceiver> mReceiver;
    ::shared_ptr<AditNavigationStatus> mEndpoint;
    SensorSourceChannel* mSensor;
};

} } /* namespace adit { namespace aauto */

#endif /* AAUTO_NAVISTATUS_CHANNEL_H */
